import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'
used_color = 'pink'
clean_empty_color = 'lightgrey'
hand_empty_color = 'whitesmoke'
text_color = 'black'

# Add dispensers
ax.add_patch(patches.Rectangle((0.5, 8), 2, 1, edgecolor='black', facecolor=ingredient1_color))
ax.text(1.5, 8.5, 'dispenser_1\n(ingredient1)', color=text_color, ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((6.5, 8), 2, 1, edgecolor='black', facecolor=ingredient2_color))
ax.text(7.5, 8.5, 'dispenser_2\n(ingredient2)', color=text_color, ha='center', va='center', fontsize=8)

# Add shots
# Shot1 is held by right hand, clean, empty
ax.add_patch(patches.Rectangle((8.5, 1), 1, 1, edgecolor='black', facecolor=clean_empty_color))
ax.text(9, 1.5, 'shot_1\nclean, empty', color=text_color, ha='center', va='center', fontsize=8)

# Shot2 is on the table, empty, used
ax.add_patch(patches.Rectangle((4.5, 5), 1, 1, edgecolor='black', facecolor=used_color))
ax.text(5, 5.5, 'shot_2\nempty, used', color=text_color, ha='center', va='center', fontsize=8)

# Shot3 is on the table, clean, empty
ax.add_patch(patches.Rectangle((8.5, 5), 1, 1, edgecolor='black', facecolor=clean_empty_color))
ax.text(9, 5.5, 'shot_3\nclean, empty', color=text_color, ha='center', va='center', fontsize=8)

# Add shaker
# Shaker1 is held by left hand
ax.add_patch(patches.Circle((1, 2), 0.75, edgecolor='black', facecolor=used_color))
ax.text(1, 2, 'shaker_1\ncontains cocktail1,\nused, shaken, l2', color=text_color, ha='center', va='center', fontsize=8)

# Add hands
# Left hand is holding shaker1
ax.add_patch(patches.Rectangle((0.5, 1), 1, 0.5, edgecolor='black', facecolor=used_color))
ax.text(1, 1.25, 'left_hand\nholding shaker1', color=text_color, ha='center', va='center', fontsize=8)

# Right hand is holding shot1
ax.add_patch(patches.Rectangle((8.5, 1), 1, 0.5, edgecolor='black', facecolor=used_color))
ax.text(9, 1.25, 'right_hand\nholding shot1', color=text_color, ha='center', va='center', fontsize=8)

# Add legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2'),
    patches.Patch(facecolor=used_color, edgecolor='black', label='used'),
    patches.Patch(facecolor=clean_empty_color, edgecolor='black', label='clean, empty'),
    patches.Patch(facecolor=hand_empty_color, edgecolor='black', label='hand empty')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 10)
ax.set_ylim(0, 10)
ax.axis('off')

# Save the figure
plt.savefig('<PATH_REMOVED>')
plt.show()